﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IMMeDotNet {

	/// <summary>
	/// Represents a connected client IM-me device.
	/// </summary>
	public class Contact {

		#region Properties

		/// <summary>
		/// Gets or sets the username of the contact.
		/// </summary>
		public IMMeString Username { get; set; }

		/// <summary>
		/// Gets or sets the ID of the contact.
		/// </summary>
		public uint ID { get; set; }

		/// <summary>
		/// Gets or sets whether the ID is online or not.
		/// </summary>
		public bool IsOnline { get; set; }

		#endregion


		/// <summary>
		/// Creates an instance of the <see cref="Client"/> class.
		/// </summary>
		/// <param name="username">The client's username.</param>
		/// <param name="id">An explicit ID assigned to the <see cref="Client"/>.</param>
		public Contact(IMMeString username, uint id) {
			this.Username = username;
			this.ID = id;
		}


		/// <summary>
		/// Creates an instance of the <see cref="Client"/> class.
		/// </summary>
		/// <param name="username">The client's username.</param>
		/// <param name="id">An explicit ID assigned to the <see cref="Client"/>.</param>
		public Contact(string username, uint id)
			: this(new IMMeString(username), id) {
		}

		/// <summary>
		/// Creates an instance of the <see cref="Client"/> class and generates an ID automatically.
		/// </summary>
		/// <param name="username">The client's username.</param>
		public Contact(IMMeString username)
			: this(username, (uint)Crc32.Calculate(username.ToByteArray())) {
		}

		/// <summary>
		/// Creates an instance of the <see cref="Client"/> class and generates an ID automatically.
		/// </summary>
		/// <param name="username">The client's username.</param>
		public Contact(string username)
			: this(new IMMeString(username)) {
		}

		public override string ToString() {
			return string.Format("{{{0:X8}:{1}}}", this.ID, this.Username);
		}

	}
}
